<?php

namespace App\Filament\Resources\TransactionResource\Pages;

use App\Filament\Resources\TransactionResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists;
use Filament\Infolists\Infolist;

class ViewTransaction extends ViewRecord
{
    protected static string $resource = TransactionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Infolists\Components\Section::make('Transaction Information')
                    ->schema([
                        Infolists\Components\TextEntry::make('transaction_id')
                            ->label('Transaction ID')
                            ->copyable()
                            ->weight('bold'),
                        
                        Infolists\Components\TextEntry::make('status')
                            ->badge()
                            ->color(fn (string $state): string => match ($state) {
                                'completed' => 'success',
                                'pending' => 'warning',
                                'failed' => 'danger',
                                default => 'gray',
                            }),
                        
                        Infolists\Components\TextEntry::make('user_name')
                            ->label('Customer Name'),
                        
                        Infolists\Components\TextEntry::make('user_phone')
                            ->label('Phone Number'),
                        
                        Infolists\Components\TextEntry::make('payment_method')
                            ->label('Payment Method')
                            ->formatStateUsing(fn (string $state): string => str_replace('_', ' ', title_case($state))),
                        
                        Infolists\Components\TextEntry::make('total_amount')
                            ->label('Total Amount')
                            ->money('USD')
                            ->size('lg')
                            ->weight('bold'),
                        
                        Infolists\Components\TextEntry::make('created_at')
                            ->label('Transaction Date')
                            ->dateTime(),
                    ])
                    ->columns(2),
                
                Infolists\Components\Section::make('Services Purchased')
                    ->schema([
                        Infolists\Components\RepeatableEntry::make('services')
                            ->schema([
                                Infolists\Components\TextEntry::make('name')
                                    ->weight('bold'),
                                
                                Infolists\Components\TextEntry::make('category')
                                    ->badge(),
                                
                                Infolists\Components\TextEntry::make('pivot.price')
                                    ->label('Price at Purchase')
                                    ->money('USD'),
                                
                                Infolists\Components\TextEntry::make('description')
                                    ->limit(100),
                            ])
                            ->columns(2)
                            ->columnSpanFull(),
                    ])
                    ->collapsible(),
            ]);
    }
}