<?php

namespace App\Filament\Resources;

use App\Filament\Resources\UserResource\Pages;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class UserResource extends Resource
{
    protected static ?string $model = User::class;

    protected static ?string $navigationIcon = 'heroicon-o-users';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('First Name')
                    ->required(),
                Forms\Components\TextInput::make('surname')
                    ->label('Last Name')
                    ->required(),
                Forms\Components\TextInput::make('email')
                    ->label('Email')
                    ->email()
                    ->required(),
                Forms\Components\TextInput::make('phone')
                    ->label('Phone Number')
                    ->tel()
                    ->nullable(),
                Forms\Components\TextInput::make('address')
                    ->label('Address')
                    ->nullable(),
                Forms\Components\TextInput::make('city')
                    ->label('City')
                    ->nullable(),
                Forms\Components\TextInput::make('province')
                    ->label('Province')
                    ->nullable(),
                Forms\Components\TextInput::make('country')
                    ->label('Country')
                    ->nullable(),
                Forms\Components\TextInput::make('nrc')
                    ->label('NRC')
                    ->required(),
                Forms\Components\Textarea::make('business_details')
                    ->label('Business Details')
                    ->nullable(),
                Forms\Components\Select::make('user_type')
                    ->label('User Type')
                    ->options([
                        'customer' => 'Customer',
                        'admin' => 'Admin',
                    ])
                    ->default('customer')
                    ->required(),
                Forms\Components\TextInput::make('phone_number')
                    ->label('Alternate Phone Number')
                    ->nullable(),
                Forms\Components\DatePicker::make('date_of_birth')
                    ->label('Date of Birth')
                    ->nullable(),
                Forms\Components\Select::make('gender')
                    ->label('Gender')
                    ->options([
                        'male' => 'Male',
                        'female' => 'Female',
                        'other' => 'Other',
                    ])
                    ->nullable(),
                Forms\Components\Select::make('marital_status')
                    ->label('Marital Status')
                    ->options([
                        'single' => 'Single',
                        'married' => 'Married',
                        'divorced' => 'Divorced',
                        'widowed' => 'Widowed',
                    ])
                    ->nullable(),
                Forms\Components\TextInput::make('nationality')
                    ->label('Nationality')
                    ->nullable(),
                Forms\Components\Select::make('membership_type')
                    ->label('Membership Type')
                    ->options([
                        'basic' => 'Basic',
                        'premium' => 'Premium',
                        'vip' => 'VIP',
                    ])
                    ->default('basic')
                    ->required(),
                Forms\Components\FileUpload::make('documents')
                    ->label('Documents')
                    ->multiple()
                    ->nullable(),
                Forms\Components\Select::make('status')
                    ->label('Status')
                    ->options([
                        'active' => 'Active',
                        'inactive' => 'Inactive',
                    ])
                    ->default('active')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('full_name')->label('Full Name'),
                Tables\Columns\TextColumn::make('email')->label('Email'),
                Tables\Columns\TextColumn::make('nrc')->label('NRC'),
                Tables\Columns\TextColumn::make('membership_type')->label('Membership Type'),
                Tables\Columns\TextColumn::make('status')->label('Status'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUsers::route('/'),
            'create' => Pages\CreateUser::route('/create'),
            'edit' => Pages\EditUser::route('/{record}/edit'),
        ];
    }
}
