<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Services;

class ServicesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'name' => 'Registration',
                'description' => 'Register for our services.',
                'price' => 50.00,
                'category' => 'general',
                'status' => 'active',
            ],
            [
                'name' => 'Insurance',
                'description' => 'Get insurance coverage for your assets.',
                'price' => 100.00,
                'category' => 'general',
                'status' => 'active',
            ],
            [
                'name' => 'Loans',
                'description' => 'Apply for a loan to finance your projects.',
                'price' => 0.00,
                'category' => 'finance',
                'status' => 'active',
            ],
            [
                'name' => 'Application Form',
                'description' => 'Fill out our application form to get started.',
                'price' => 0.00,
                'category' => 'general',
                'status' => 'active',
            ],
            [
                'name' => 'Annual Returns',
                'description' => 'File your annual returns with us.',
                'price' => 75.00,
                'category' => 'finance',
                'status' => 'active',
            ],
            [
                'name' => 'Membership Renewal',
                'description' => 'Renew your membership to continue enjoying our services.',
                'price' => 25.00,
                'category' => 'general',
                'status' => 'active',
            ],
            [
                'name' => 'Farmers Trainings',
                'description' => 'Attend our training sessions to improve your farming skills.',
                'price' => 0.00,
                'category' => 'training',
                'status' => 'active',
            ],
            [
                'name' => 'SMEs Training',
                'description' => 'Training programs for small and medium enterprises.',
                'price' => 0.00,
                'category' => 'training',
                'status' => 'active',
            ],
            [
                'name' => 'Tailor Made Programs',
                'description' => 'Customized programs to meet your specific needs.',
                'price' => 150.00,
                'category' => 'consulting',
                'status' => 'active',
            ],
            [
                'name' => 'Application Forms',
                'description' => 'Access various application forms for our services.',
                'price' => 0.00,
                'category' => 'general',
                'status' => 'active',
            ],
        ];

        foreach ($services as $service) {
            Services::create($service);
        }
    }
}
