<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shopping Cart - SindaSystem</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    @livewireStyles
    <style>
        body { 
            font-family: 'Inter', sans-serif;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        .gradient-bg { 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
        }
        
        /* Mobile-first responsive animations */
        .cart-item {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .cart-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
        }
        
        /* Responsive text scaling */
        @media (max-width: 640px) {
            .hero-title {
                font-size: 1.875rem;
                line-height: 2.25rem;
            }
            .hero-subtitle {
                font-size: 0.875rem;
                line-height: 1.25rem;
            }
        }
        
        @media (min-width: 641px) and (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
                line-height: 3rem;
            }
            .hero-subtitle {
                font-size: 1rem;
                line-height: 1.5rem;
            }
        }
        
        /* Loading animation */
        .loading-pulse {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: .5; }
        }
        
        /* Print styles */
        @media print {
            .no-print { display: none !important; }
            .gradient-bg { background: #667eea !important; }
        }
        
        /* Reduced motion support */
        @media (prefers-reduced-motion: reduce) {
            .cart-item,
            * {
                transition: none !important;
                animation: none !important;
            }
        }
    </style>
</head>
<body class="bg-white min-h-screen">
    <!-- Header - Fully Responsive -->
    <header class="gradient-bg shadow-lg">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Mobile Header (< 768px) -->
            <div class="flex items-center justify-between py-4 md:hidden">
                <div class="flex items-center min-w-0 flex-1">
                    <h1 class="hero-title text-2xl font-bold text-white truncate">
                        <i class="fas fa-shopping-cart mr-2"></i>
                        <span class="hidden xs:inline">Shopping </span>Cart
                    </h1>
                </div>
                <a href="{{ route('services.index') }}" 
                   class="flex-shrink-0 bg-white bg-opacity-20 hover:bg-opacity-30 text-white px-3 py-2 rounded-lg transition-all duration-200 text-sm">
                    <i class="fas fa-arrow-left mr-1"></i>
                    <span class="hidden xs:inline">Continue </span>Shop
                </a>
            </div>

            <!-- Tablet & Desktop Header (>= 768px) -->
            <div class="hidden md:flex items-center justify-between py-6 lg:py-8">
                <div class="flex-1 min-w-0">
                    <h1 class="hero-title text-3xl lg:text-4xl font-bold text-white mb-2">
                        <i class="fas fa-shopping-cart mr-2 lg:mr-3"></i>Shopping Cart
                    </h1>
                    <p class="hero-subtitle text-blue-100 text-base lg:text-lg">
                        Review your selected services
                    </p>
                </div>
                <div class="flex-shrink-0 ml-6">
                    <a href="{{ route('services.index') }}" 
                       class="bg-white bg-opacity-20 hover:bg-opacity-30 text-white px-4 lg:px-6 py-2 lg:py-3 rounded-lg transition-all duration-200">
                        <i class="fas fa-arrow-left mr-2"></i>Continue Shopping
                    </a>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Content Container -->
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-6 sm:py-8 lg:py-12">
        <!-- Flash Messages - Responsive -->
        @if(session('message'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-4 sm:mb-6 flex items-start sm:items-center">
                <i class="fas fa-check-circle mr-2 mt-0.5 sm:mt-0 flex-shrink-0"></i>
                <span class="text-sm sm:text-base">{{ session('message') }}</span>
            </div>
        @endif

        @if($services->count() > 0)
            <!-- Cart Items Section -->
            <div class="max-w-none sm:max-w-2xl md:max-w-4xl lg:max-w-6xl mx-auto">
                <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                    <!-- Cart Header -->
                    <div class="p-4 sm:p-6 border-b border-gray-200">
                        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
                            <h2 class="text-xl sm:text-2xl font-bold text-gray-900 mb-2 sm:mb-0">
                                Cart Items
                            </h2>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                {{ $services->count() }} {{ Str::plural('item', $services->count()) }}
                            </span>
                        </div>
                    </div>
                    
                    <!-- Cart Items List -->
                    <div class="divide-y divide-gray-200">
                        @foreach($services as $service)
                            <div class="cart-item p-4 sm:p-6">
                                <!-- Mobile Layout (< 640px) -->
                                <div class="block sm:hidden">
                                    <div class="flex items-start space-x-3">
                                        <!-- Service Icon/Image -->
                                        <div class="flex-shrink-0 w-16 h-16 bg-gradient-to-br from-blue-400 to-purple-500 rounded-lg flex items-center justify-center">
                                            @if($service->image)
                                                <img src="{{ $service->image }}" alt="{{ $service->name }}" class="w-full h-full object-cover rounded-lg">
                                            @else
                                                <i class="fas fa-cog text-white text-xl"></i>
                                            @endif
                                        </div>
                                        
                                        <!-- Service Details -->
                                        <div class="flex-1 min-w-0">
                                            <h3 class="text-base font-semibold text-gray-900 truncate">{{ $service->name }}</h3>
                                            <p class="text-sm text-gray-600 mt-1 line-clamp-2">{{ Str::limit($service->description, 80) }}</p>
                                            
                                            @if($service->category)
                                                <span class="inline-block bg-blue-100 text-blue-800 text-xs font-semibold px-2 py-1 rounded-full mt-2">
                                                    {{ ucfirst($service->category) }}
                                                </span>
                                            @endif
                                            
                                            <!-- Price and Actions -->
                                            <div class="flex items-center justify-between mt-3">
                                                <div>
                                                    <p class="text-lg font-bold text-green-600">ZMW {{ number_format($service->price, 2) }}</p>
                                                    @if($service->original_price && $service->original_price > $service->price)
                                                        <p class="text-xs text-gray-500 line-through">${{ number_format($service->original_price, 2) }}</p>
                                                    @endif
                                                </div>
                                                <form action="{{ route('cart.remove', $service->id) }}" method="POST" class="inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" 
                                                            class="text-red-500 hover:text-red-700 p-2 rounded-lg hover:bg-red-50 transition-all duration-200"
                                                            onclick="return confirm('Remove this item from cart?')">
                                                        <i class="fas fa-trash text-sm"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tablet & Desktop Layout (>= 640px) -->
                                <div class="hidden sm:flex items-center justify-between">
                                    <div class="flex items-center space-x-4 flex-1 min-w-0">
                                        <!-- Service Icon/Image -->
                                        <div class="flex-shrink-0 w-20 h-20 bg-gradient-to-br from-blue-400 to-purple-500 rounded-lg flex items-center justify-center">
                                            @if($service->image)
                                                <img src="{{ $service->image }}" alt="{{ $service->name }}" class="w-full h-full object-cover rounded-lg">
                                            @else
                                                <i class="fas fa-cog text-white text-2xl"></i>
                                            @endif
                                        </div>
                                        
                                        <!-- Service Details -->
                                        <div class="flex-1 min-w-0">
                                            <h3 class="text-lg font-semibold text-gray-900">{{ $service->name }}</h3>
                                            <p class="text-gray-600 mt-1">{{ Str::limit($service->description, 120) }}</p>
                                            @if($service->category)
                                                <span class="inline-block bg-blue-100 text-blue-800 text-xs font-semibold px-2.5 py-0.5 rounded-full mt-2">
                                                    {{ ucfirst($service->category) }}
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    
                                    <!-- Price and Actions -->
                                    <div class="flex items-center space-x-4 flex-shrink-0">
                                        <div class="text-right">
                                            <p class="text-2xl font-bold text-green-600">${{ number_format($service->price, 2) }}</p>
                                            @if($service->original_price && $service->original_price > $service->price)
                                                <p class="text-sm text-gray-500 line-through">${{ number_format($service->original_price, 2) }}</p>
                                            @endif
                                        </div>
                                        <form action="{{ route('cart.remove', $service->id) }}" method="POST" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="text-red-500 hover:text-red-700 p-3 rounded-lg hover:bg-red-50 transition-all duration-200"
                                                    onclick="return confirm('Remove this item from cart?')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Cart Summary -->
                    <div class="bg-gray-50 p-4 sm:p-6">
                        <!-- Total Section -->
                        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between mb-6">
                            <div class="mb-4 sm:mb-0">
                                <span class="text-lg sm:text-2xl font-bold text-gray-900">Total:</span>
                                <p class="text-sm text-gray-600 mt-1">Including all selected services</p>
                            </div>
                            <div class="text-right">
                                <span class="text-2xl sm:text-3xl font-bold text-green-600">ZMW{{ number_format($total, 2) }}</span>
                                <p class="text-sm text-gray-500 mt-1">{{ $services->count() }} {{ Str::plural('service', $services->count()) }}</p>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4">
                            <!-- Clear Cart Button -->
                            <form action="{{ route('cart.clear') }}" method="POST" class="order-2 sm:order-1">
                                @csrf
                                <button type="submit" 
                                        class="w-full bg-red-500 hover:bg-red-600 text-white font-bold py-3 px-4 sm:px-6 rounded-lg transition-all duration-200 flex items-center justify-center"
                                        onclick="return confirm('Are you sure you want to clear your cart?')">
                                    <i class="fas fa-trash mr-2"></i>
                                    <span class="text-sm sm:text-base">Clear Cart</span>
                                </button>
                            </form>
                            
                            <!-- Checkout Button -->
                            <a href="{{ route('checkout.index') }}" 
                               class="order-1 sm:order-2 w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 sm:px-6 rounded-lg transition-all duration-200 flex items-center justify-center text-center">
                                <i class="fas fa-credit-card mr-2"></i>
                                <span class="text-sm sm:text-base">Proceed to Checkout</span>
                            </a>
                        </div>

                        <!-- Additional Info -->
                        <div class="mt-6 pt-4 border-t border-gray-200">
                            <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 text-center">
                                <div class="flex items-center justify-center text-sm text-gray-600">
                                    <i class="fas fa-shield-alt mr-2 text-green-500"></i>
                                    <span>Secure Payment</span>
                                </div>
                                <div class="flex items-center justify-center text-sm text-gray-600">
                                    <i class="fas fa-clock mr-2 text-blue-500"></i>
                                    <span>Quick Processing</span>
                                </div>
                                <div class="flex items-center justify-center text-sm text-gray-600">
                                    <i class="fas fa-headset mr-2 text-purple-500"></i>
                                    <span>24/7 Support</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <!-- Empty Cart State - Responsive -->
            <div class="max-w-sm sm:max-w-md md:max-w-2xl mx-auto text-center">
                <div class="bg-white rounded-xl shadow-lg p-8 sm:p-12">
                    <!-- Empty Cart Icon -->
                    <div class="mb-6">
                        <i class="fas fa-shopping-cart text-4xl sm:text-6xl text-gray-300 mb-4"></i>
                    </div>
                    
                    <!-- Empty Cart Content -->
                    <div class="space-y-4">
                        <h2 class="text-xl sm:text-2xl font-bold text-gray-900">Your cart is empty</h2>
                        <p class="text-sm sm:text-base text-gray-600 max-w-md mx-auto">
                            Looks like you haven't added any services to your cart yet. 
                            <span class="hidden sm:inline">Browse our amazing services and find something you love!</span>
                        </p>
                        
                        <!-- Browse Services Button -->
                        <div class="pt-4">
                            <a href="{{ route('services.index') }}" 
                               class="inline-flex items-center bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 sm:px-8 rounded-lg transition-all duration-200 transform hover:scale-105">
                                <i class="fas fa-shopping-bag mr-2"></i>
                                <span class="text-sm sm:text-base">Browse Services</span>
                            </a>
                        </div>
                        
                        <!-- Additional Actions -->
                        <div class="pt-6 border-t border-gray-200 mt-8">
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 text-sm">
                                <a href="#" class="flex items-center justify-center text-gray-600 hover:text-blue-600 transition-colors duration-200">
                                    <i class="fas fa-star mr-2"></i>
                                    Popular Services
                                </a>
                                <a href="#" class="flex items-center justify-center text-gray-600 hover:text-blue-600 transition-colors duration-200">
                                    <i class="fas fa-tags mr-2"></i>
                                    Special Offers
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <!-- Related Services Section (when cart has items) -->
        @if($services->count() > 0)
            <div class="mt-8 sm:mt-12">
                <div class="max-w-none sm:max-w-2xl md:max-w-4xl lg:max-w-6xl mx-auto">
                    <div class="bg-white rounded-xl shadow-lg p-4 sm:p-6">
                        <h3 class="text-lg sm:text-xl font-bold text-gray-900 mb-4">You might also like</h3>
                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                            <!-- Placeholder for related services -->
                            <div class="bg-gray-50 rounded-lg p-4 text-center">
                                <i class="fas fa-plus text-2xl text-gray-400 mb-2"></i>
                                <p class="text-sm text-gray-600">More services coming soon</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Footer - Responsive -->
    <footer class="bg-gray-800 text-white py-6 sm:py-8 mt-8 sm:mt-12 lg:mt-16 no-print">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Mobile Footer -->
            <div class="block sm:hidden text-center">
                <div class="mb-4">
                    <h3 class="text-lg font-semibold mb-2">SindaSystem</h3>
                    <p class="text-gray-400 text-sm">Professional services for your needs</p>
                </div>
                
                <!-- Quick Links -->
                <div class="grid grid-cols-2 gap-4 mb-6 text-sm">
                    <div>
                        <a href="{{ route('services.index') }}" class="block text-gray-400 hover:text-white transition-colors py-1">Services</a>
                        <a href="#" class="block text-gray-400 hover:text-white transition-colors py-1">About</a>
                    </div>
                    <div>
                        <a href="#" class="block text-gray-400 hover:text-white transition-colors py-1">Support</a>
                        <a href="#" class="block text-gray-400 hover:text-white transition-colors py-1">Contact</a>
                    </div>
                </div>

                <!-- Social Links -->
                <div class="flex justify-center space-x-4 mb-4">
                    <a href="#" class="text-gray-400 hover:text-white transition-colors">
                        <i class="fab fa-facebook text-lg"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition-colors">
                        <i class="fab fa-twitter text-lg"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition-colors">
                        <i class="fab fa-linkedin text-lg"></i>
                    </a>
                </div>

                <!-- Copyright -->
                <div class="border-t border-gray-700 pt-4">
                    <p class="text-gray-400 text-xs">&copy; 2024 SindaSystem. All rights reserved.</p>
                </div>
            </div>

            <!-- Desktop Footer -->
            <div class="hidden sm:block">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
                    <!-- Company Info -->
                    <div class="md:col-span-2">
                        <h3 class="text-xl font-semibold mb-4">SindaSystem</h3>
                        <p class="text-gray-400 mb-4 max-w-md">
                            Professional services tailored to meet your business needs. 
                            Quality, reliability, and excellence in every project.
                        </p>
                        <div class="flex space-x-4">
                            <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                                <i class="fab fa-facebook"></i>
                            </a>
                            <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                                <i class="fab fa-linkedin"></i>
                            </a>
                            <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </div>
                    </div>

                    <!-- Quick Links -->
                    <div>
                        <h4 class="font-semibold mb-4">Quick Links</h4>
                        <ul class="space-y-2 text-sm">
                            <li><a href="{{ route('services.index') }}" class="text-gray-400 hover:text-white transition-colors">All Services</a></li>
                            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">About Us</a></li>
                            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Contact</a></li>
                            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">FAQ</a></li>
                        </ul>
                    </div>

                    <!-- Support -->
                    <div>
                        <h4 class="font-semibold mb-4">Support</h4>
                        <ul class="space-y-2 text-sm">
                            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Help Center</a></li>
                            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Privacy Policy</a></li>
                            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Terms of Service</a></li>
                            <li><a href="#" class="text-gray-400 hover:text-white transition-colors">Refund Policy</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Copyright -->
                <div class="border-t border-gray-700 pt-6 text-center">
                    <p class="text-gray-400 text-sm">
                        &copy; 2024 SindaSystem. All rights reserved. | 
                        <a href="#" class="hover:text-white transition-colors">Privacy</a> | 
                        <a href="#" class="hover:text-white transition-colors">Terms</a>
                    </p>
                </div>
            </div>
        </div>
    </footer>

    @livewireScripts

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add loading states to forms
            const forms = document.querySelectorAll('form');
            forms.forEach(form => {
                form.addEventListener('submit', function() {
                    const button = form.querySelector('button[type="submit"]');
                    if (button) {
                        button.disabled = true;
                        button.classList.add('loading-pulse');
                        const originalText = button.innerHTML;
                        button.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Processing...';
                        
                        // Re-enable after 5 seconds as fallback
                        setTimeout(() => {
                            button.disabled = false;
                            button.classList.remove('loading-pulse');
                            button.innerHTML = originalText;
                        }, 5000);
                    }
                });
            });

            // Smooth scroll for anchor links
            document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                anchor.addEventListener('click', function (e) {
                    e.preventDefault();
                    const target = document.querySelector(this.getAttribute('href'));
                    if (target) {
                        target.scrollIntoView({
                            behavior: 'smooth',
                            block: 'start'
                        });
                    }
                });
            });

            // Add intersection observer for animations
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }
                });
            }, observerOptions);

            // Observe cart items for fade-in animation
            const cartItems = document.querySelectorAll('.cart-item');
            cartItems.forEach((item, index) => {
                item.style.opacity = '0';
                item.style.transform = 'translateY(20px)';
                item.style.transition = `opacity 0.6s ease ${index * 0.1}s, transform 0.6s ease ${index * 0.1}s`;
                observer.observe(item);
            });

            // Add keyboard navigation support
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Tab') {
                    document.body.classList.add('keyboard-navigation');
                }
            });

            document.addEventListener('mousedown', function() {
                document.body.classList.remove('keyboard-navigation');
            });

            // Auto-hide flash messages after 5 seconds
            const flashMessages = document.querySelectorAll('[class*="bg-green-100"], [class*="bg-red-100"], [class*="bg-yellow-100"]');
            flashMessages.forEach(message => {
                setTimeout(() => {
                    message.style.transition = 'opacity 0.5s ease';
                    message.style.opacity = '0';
                    setTimeout(() => {
                        message.remove();
                    }, 500);
                }, 5000);
            });

            // Add touch feedback for mobile
            if ('ontouchstart' in window) {
                const touchElements = document.querySelectorAll('button, a, [role="button"]');
                touchElements.forEach(element => {
                    element.addEventListener('touchstart', function() {
                        this.style.transform = 'scale(0.98)';
                    });
                    
                    element.addEventListener('touchend', function() {
                        this.style.transform = '';
                    });
                });
            }

            // Performance: Lazy load images if any
            if ('IntersectionObserver' in window) {
                const imageObserver = new IntersectionObserver(function(entries, observer) {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            const img = entry.target;
                            if (img.dataset.src) {
                                img.src = img.dataset.src;
                                img.classList.remove('lazy');
                                imageObserver.unobserve(img);
                            }
                        }
                    });
                });

                document.querySelectorAll('img[data-src]').forEach(img => {
                    imageObserver.observe(img);
                });
            }
        });

        // Add CSS for keyboard navigation
        const keyboardStyles = document.createElement('style');
        keyboardStyles.textContent = `
            .keyboard-navigation *:focus {
                outline: 2px solid #3b82f6 !important;
                outline-offset: 2px !important;
            }
            
            /* Enhanced focus styles for better accessibility */
            .keyboard-navigation button:focus,
            .keyboard-navigation a:focus {
                box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.3) !important;
            }
            
            /* Loading state styles */
            .loading-pulse {
                position: relative;
                overflow: hidden;
            }
            
            .loading-pulse::after {
                content: '';
                position: absolute;
                top: 0;
                left: -100%;
                width: 100%;
                height: 100%;
                background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
                animation: loading-shimmer 1.5s infinite;
            }
            
            @keyframes loading-shimmer {
                0% { left: -100%; }
                100% { left: 100%; }
            }
            
            /* Responsive utilities */
            @media (max-width: 375px) {
                .container {
                    padding-left: 0.75rem;
                    padding-right: 0.75rem;
                }
                
                .cart-item {
                    padding: 1rem;
                }
                
                .hero-title {
                    font-size: 1.5rem;
                    line-height: 2rem;
                }
            }
            
            /* High contrast mode support */
            @media (prefers-contrast: high) {
                .bg-gray-50 {
                    background-color: #f9fafb !important;
                }
                
                .text-gray-600 {
                    color: #374151 !important;
                }
                
                .border-gray-200 {
                    border-color: #6b7280 !important;
                }
            }
            
            /* Dark mode support */
            @media (prefers-color-scheme: dark) {
                .bg-white {
                    background-color: #1f2937;
                    color: #f9fafb;
                }
                
                .text-gray-900 {
                    color: #f9fafb !important;
                }
                
                .text-gray-600 {
                    color: #d1d5db !important;
                }
                
                .bg-gray-50 {
                    background-color: #111827;
                }
                
                .border-gray-200 {
                    border-color: #374151 !important;
                }
            }
            
            /* Print optimizations */
            @media print {
                .no-print {
                    display: none !important;
                }
                
                .cart-item {
                    break-inside: avoid;
                    page-break-inside: avoid;
                }
                
                .bg-white {
                    background: white !important;
                    box-shadow: none !important;
                }
                
                .text-green-600 {
                    color: #000 !important;
                }
                
                .gradient-bg {
                    background: #667eea !important;
                    color: white !important;
                }
            }
            
            /* Landscape orientation adjustments */
            @media (max-height: 500px) and (orientation: landscape) {
                .py-6 {
                    padding-top: 1rem;
                    padding-bottom: 1rem;
                }
                
                .py-8 {
                    padding-top: 1.5rem;
                    padding-bottom: 1.5rem;
                }
                
                .hero-title {
                    font-size: 1.5rem;
                    line-height: 2rem;
                    margin-bottom: 0.5rem;
                }
            }
            
            /* Ultra-wide screen support */
            @media (min-width: 1920px) {
                .container {
                    max-width: 1400px;
                }
            }
            
            /* Hover effects for touch devices */
            @media (hover: none) {
                .cart-item:hover {
                    transform: none;
                    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
                }
                
                button:hover,
                a:hover {
                    transform: none;
                }
            }
            
            /* Animation performance optimization */
            .cart-item,
            button,
            a {
                will-change: transform;
                backface-visibility: hidden;
                perspective: 1000px;
            }
            
            /* Smooth scrolling */
            html {
                scroll-behavior: smooth;
            }
            
            /* Better text rendering */
            body {
                text-rendering: optimizeLegibility;
                -webkit-font-smoothing: antialiased;
                -moz-osx-font-smoothing: grayscale;
            }
            
            /* Line clamping utility */
            .line-clamp-2 {
                display: -webkit-box;
                -webkit-line-clamp: 2;
                -webkit-box-orient: vertical;
                overflow: hidden;
            }
            
            /* Custom scrollbar for webkit browsers */
            ::-webkit-scrollbar {
                width: 8px;
            }
            
            ::-webkit-scrollbar-track {
                background: #f1f1f1;
                border-radius: 4px;
            }
            
            ::-webkit-scrollbar-thumb {
                background: #c1c1c1;
                border-radius: 4px;
            }
            
            ::-webkit-scrollbar-thumb:hover {
                background: #a8a8a8;
            }
            
            /* Focus trap for modals/overlays */
            .focus-trap {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                pointer-events: none;
                z-index: 9999;
            }
            
            /* Screen reader only content */
            .sr-only {
                position: absolute;
                width: 1px;
                height: 1px;
                padding: 0;
                margin: -1px;
                overflow: hidden;
                clip: rect(0, 0, 0, 0);
                white-space: nowrap;
                border: 0;
            }
        `;
        document.head.appendChild(keyboardStyles);

        // Error handling for network requests
        window.addEventListener('online', function() {
            console.log('Connection restored');
            // You could show a notification here
        });

        window.addEventListener('offline', function() {
            console.log('Connection lost');
            // You could show an offline notification here
        });

        // Performance monitoring
        if ('performance' in window) {
            window.addEventListener('load', function() {
                setTimeout(function() {
                    const perfData = performance.getEntriesByType('navigation')[0];
                    if (perfData) {
                        console.log('Page load time:', perfData.loadEventEnd - perfData.loadEventStart, 'ms');
                    }
                }, 0);
            });
        }
    </script>

    <!-- Structured Data for SEO -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "ShoppingCart",
        "name": "SindaSystem Shopping Cart",
        "description": "Review and manage your selected services",
        "provider": {
            "@type": "Organization",
            "name": "SindaSystem",
            "url": "{{ url('/') }}"
        }
        @if($services->count() > 0)
        ,
        "itemListElement": [
            @foreach($services as $index => $service)
            {
                "@type": "Service",
                "position": {{ $index + 1 }},
                "name": "{{ $service->name }}",
                "description": "{{ Str::limit($service->description, 100) }}",
                "offers": {
                    "@type": "Offer",
                    "price": "{{ $service->price }}",
                    "priceCurrency": "USD"
                }
            }@if(!$loop->last),@endif
            @endforeach
        ],
        "totalPrice": "{{ $total }}",
        "priceCurrency": "USD"
        @endif
    }
    </script>
</body>
</html>
