<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - SindaSystem</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .payment-fields { display: none; }
        .payment-fields.active { display: block; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
    <header class="gradient-bg shadow-lg">
        <div class="container mx-auto px-6 py-8">
            <h1 class="text-4xl font-bold text-white">
                <i class="fas fa-credit-card mr-3"></i>Checkout
            </h1>
            <p class="text-blue-100 text-lg">Complete your purchase</p>
        </div>
    </header>

    <div class="container mx-auto px-6 py-12">
        <div class="max-w-4xl mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                <!-- Order Summary -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6">Order Summary</h2>
                    
                    <div class="space-y-4">
                        @foreach($services as $service)
                            <div class="flex justify-between items-center py-3 border-b border-gray-200">
                                <div>
                                    <h3 class="font-semibold text-gray-900">{{ $service->name }}</h3>
                                    @if($service->category)
                                        <span class="text-sm text-gray-500">{{ ucfirst($service->category) }}</span>
                                    @endif
                                </div>
                                <span class="font-bold text-green-600">ZMW {{ number_format($service->price, 2) }}</span>
                            </div>
                        @endforeach
                    </div>
                    
                    <div class="mt-6 pt-6 border-t border-gray-200">
                        <div class="flex justify-between items-center">
                            <span class="text-xl font-bold text-gray-900">Total:</span>
                            <span class="text-2xl font-bold text-green-600">ZMW {{ number_format($total, 2) }}</span>
                        </div>
                    </div>
                </div>

                <!-- Payment Form -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6">Payment Details</h2>
                    
                    @if(session('error'))
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg mb-6">
                            <i class="fas fa-exclamation-circle mr-2"></i>
                            {{ session('error') }}
                        </div>
                    @endif


                    <form action="{{ route('checkout.store') }}" method="POST" class="space-y-6" id="checkout-form">
                        @csrf


















                        <!-- Customer Information -->
                        <div class="bg-gray-50 rounded-lg p-4">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Customer Information</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-gray-700 text-sm font-bold mb-2" for="user_name">
                                        <i class="fas fa-user mr-2"></i>Full Name
                                    </label>
                                    <input 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('user_name') border-red-500 @enderror" 
                                        id="user_name" 
                                        name="user_name" 
                                        type="text" 
                                        placeholder="Enter your full name"
                                        value="{{ old('user_name') }}"
                                        required
                                    >
                                    @error('user_name')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

















                                <div>
                                    <label class="block text-gray-700 text-sm font-bold mb-2" for="user_phone">
                                        <i class="fas fa-phone mr-2"></i>Phone Number
                                    </label>
                                    <input 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('user_phone') border-red-500 @enderror" 
                                        id="user_phone" 
                                        name="user_phone" 
                                        type="tel" 
                                        placeholder="Enter your phone number"
                                        value="{{ old('user_phone') }}"
                                        required
                                    >
                                    @error('user_phone')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Payment Method Selection -->
                        <div>

                            <label class="block text-gray-700 text-sm font-bold mb-4">
                                <i class="fas fa-credit-card mr-2"></i>Payment Method
                            </label>

















                            
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <label class="payment-method-option cursor-pointer">
                                    <input type="radio" name="payment_method" value="mobile_money" class="sr-only payment-method-radio" {{ old('payment_method') == 'mobile_money' ? 'checked' : '' }}>
                                    <div class="border-2 border-gray-300 rounded-lg p-4 text-center hover:border-blue-500 transition-all duration-200">
                                        <i class="fas fa-mobile-alt text-2xl text-blue-500 mb-2"></i>
                                        <p class="font-semibold">Mobile Money</p>
                                        <p class="text-sm text-gray-500">Pay with mobile money</p>
                                    </div>
                                </label>

                                <label class="payment-method-option cursor-pointer">
                                    <input type="radio" name="payment_method" value="card" class="sr-only payment-method-radio" {{ old('payment_method') == 'card' ? 'checked' : '' }}>
                                    <div class="border-2 border-gray-300 rounded-lg p-4 text-center hover:border-blue-500 transition-all duration-200">
                                        <i class="fas fa-credit-card text-2xl text-green-500 mb-2"></i>
                                        <p class="font-semibold">Credit/Debit Card</p>
                                        <p class="text-sm text-gray-500">Pay with card</p>
                                    </div>
                                </label>

                                <label class="payment-method-option cursor-pointer">
                                    <input type="radio" name="payment_method" value="bank_transfer" class="sr-only payment-method-radio" {{ old('payment_method') == 'bank_transfer' ? 'checked' : '' }}>
                                    <div class="border-2 border-gray-300 rounded-lg p-4 text-center hover:border-blue-500 transition-all duration-200">
                                        <i class="fas fa-university text-2xl text-purple-500 mb-2"></i>
                                        <p class="font-semibold">Bank Transfer</p>
                                        <p class="text-sm text-gray-500">Direct bank transfer</p>
                                    </div>
                                </label>
                            </div>
                            @error('payment_method')
                                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Mobile Money Fields -->
                        <div id="mobile-money-fields" class="payment-fields bg-blue-50 rounded-lg p-4">
                            <h4 class="font-semibold text-blue-900 mb-4">
                                <i class="fas fa-mobile-alt mr-2"></i>Mobile Money Details
                            </h4>
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2" for="mobile_money_phone">
                                    Mobile Money Phone Number
                                </label>
                                <input 
                                    class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('mobile_money_phone') border-red-500 @enderror" 
                                    id="mobile_money_phone" 
                                    name="mobile_money_phone" 
                                    type="tel" 
                                    placeholder="Enter mobile money phone number"
                                    value="{{ old('mobile_money_phone') }}"
                                >
                                @error('mobile_money_phone')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                                <p class="text-sm text-gray-600 mt-1">
                                    <i class="fas fa-info-circle mr-1"></i>
                                    You will receive a prompt on your phone to complete the payment
                                </p>
                            </div>
                        </div>

                        <!-- Card Payment Fields -->
                        <div id="card-fields" class="payment-fields bg-green-50 rounded-lg p-4">
                            <h4 class="font-semibold text-green-900 mb-4">
                                <i class="fas fa-credit-card mr-2"></i>Card Details
                            </h4>
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-gray-700 text-sm font-bold mb-2" for="card_name">
                                        Cardholder Name
                                    </label>
                                    <input 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('card_name') border-red-500 @enderror" 
                                        id="card_name" 
                                        name="card_name" 
                                        type="text" 
                                        placeholder="Name on card"
                                        value="{{ old('card_name') }}"
                                    >
                                    @error('card_name')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label class="block text-gray-700 text-sm font-bold mb-2" for="card_number">
                                        Card Number
                                    </label>
                                    <input 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('card_number') border-red-500 @enderror" 
                                        id="card_number" 
                                        name="card_number" 
                                        type="text" 
                                        placeholder="1234 5678 9012 3456"
                                        maxlength="19"
                                        value="{{ old('card_number') }}"
                                    >
                                    @error('card_number')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-gray-700 text-sm font-bold mb-2" for="card_expiry">
                                            Expiry Date
                                        </label>
                                        <input 
                                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('card_expiry') border-red-500 @enderror" 
                                            id="card_expiry" 
                                            name="card_expiry" 
                                            type="text" 
                                            placeholder="MM/YY"
                                            maxlength="5"
                                            value="{{ old('card_expiry') }}"
                                        >
                                        @error('card_expiry')
                                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div>
                                        <label class="block text-gray-700 text-sm font-bold mb-2" for="card_cvv">
                                            CVV
                                        </label>
                                        <input 
                                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('card_cvv') border-red-500 @enderror" 
                                            id="card_cvv" 
                                            name="card_cvv" 
                                            type="text" 
                                            placeholder="123"
                                            maxlength="4"
                                            value="{{ old('card_cvv') }}"
                                        >
                                        @error('card_cvv')
                                            <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Bank Transfer Fields -->
                        <div id="bank-transfer-fields" class="payment-fields bg-purple-50 rounded-lg p-4">
                            <h4 class="font-semibold text-purple-900 mb-4">
                                <i class="fas fa-university mr-2"></i>Bank Transfer Instructions
                            </h4>
                            <div class="bg-white rounded-lg p-4 border border-purple-200">
                                <h5 class="font-semibold text-gray-900 mb-2">Transfer Details:</h5>
                                <div class="space-y-2 text-sm">
                                    <p><strong>Bank:</strong> SindaSystem Bank</p>
                                    <p><strong>Account Name:</strong> SindaSystem Ltd</p>
                                    <p><strong>Account Number:</strong> 1234567890</p>
                                    <p><strong>Amount:</strong> ${{ number_format($total, 2) }}</p>
                                    <p><strong>Reference:</strong> Your name + phone number</p>
                                </div>
                                <div class="mt-3 p-3 bg-yellow-50 border border-yellow-200 rounded">
                                    <p class="text-sm text-yellow-800">
                                        <i class="fas fa-exclamation-triangle mr-1"></i>
                                        Please complete the transfer and we'll verify payment within 24 hours.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" name="total_amount" value="{{ $total }}">

                        <div class="flex space-x-4">
                            <a href="{{ route('cart.index') }}" 
                               class="flex-1 bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-6 rounded-lg transition-all duration-200 text-center">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Cart
                            </a>
                            
                            <button 
                                class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition-all duration-200" 
                                type="submit"
                                id="pay-button"
                            >
                                <i class="fas fa-lock mr-2"></i>Pay Now
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const paymentMethodRadios = document.querySelectorAll('.payment-method-radio');
            const paymentFields = document.querySelectorAll('.payment-fields');
            const paymentOptions = document.querySelectorAll('.payment-method-option');

            // Handle payment method selection
            paymentMethodRadios.forEach(radio => {
                radio.addEventListener('change', function() {
                    // Hide all payment fields
                    paymentFields.forEach(field => {
                        field.classList.remove('active');
                    });

                    // Remove active class from all options
                    paymentOptions.forEach(option => {
                        option.querySelector('div').classList.remove('border-blue-500', 'bg-blue-50');
                        option.querySelector('div').classList.add('border-gray-300');
                    });

                    // Add active class to selected option
                    this.closest('.payment-method-option').querySelector('div').classList.remove('border-gray-300');
                    this.closest('.payment-method-option').querySelector('div').classList.add('border-blue-500', 'bg-blue-50');

                    // Show relevant payment fields
                    const selectedMethod = this.value;
                    if (selectedMethod === 'mobile_money') {
                        document.getElementById('mobile-money-fields').classList.add('active');
                    } else if (selectedMethod === 'card') {
                        document.getElementById('card-fields').classList.add('active');
                    } else if (selectedMethod === 'bank_transfer') {
                        document.getElementById('bank-transfer-fields').classList.add('active');
                    }
                });
            });

            // Format card number input
            const cardNumberInput = document.getElementById('card_number');
            if (cardNumberInput) {
                cardNumberInput.addEventListener('input', function(e) {
                    let value = e.target.value.replace(/\s+/g, '').replace(/[^0-9]/gi, '');
                    let formattedValue = value.match(/.{1,4}/g)?.join(' ') || value;
                    if (formattedValue.length > 19) formattedValue = formattedValue.substr(0, 19);
                    this.value = formattedValue;
                });
            }

            // Format expiry date input
            const cardExpiryInput = document.getElementById('card_expiry');
            if (cardExpiryInput) {
                cardExpiryInput.addEventListener('input', function(e) {
                    let value = e.target.value.replace(/\D/g, '');
                    if (value.length >= 2) {
                        value = value.substring(0, 2) + '/' + value.substring(2, 4);
                    }
                    this.value = value;
                });
            }

            // CVV input - numbers only
            const cardCvvInput = document.getElementById('card_cvv');
            if (cardCvvInput) {
                cardCvvInput.addEventListener('input', function(e) {
                    this.value = this.value.replace(/\D/g, '');
                });
            }

            // Initialize with selected payment method if any
            const checkedRadio = document.querySelector('.payment-method-radio:checked');
            if (checkedRadio) {
                checkedRadio.dispatchEvent(new Event('change'));
            }
        });
    </script>
</body>
</html>
