<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - SindaSystem</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #10b981 0%, #059669 100%); }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
    <header class="gradient-bg shadow-lg">
        <div class="container mx-auto px-6 py-8">
            <div class="text-center">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-white bg-opacity-20 rounded-full mb-4">
                    <i class="fas fa-check text-3xl text-white"></i>
                </div>
                <h1 class="text-4xl font-bold text-white mb-2">Payment Successful!</h1>
                <p class="text-green-100 text-lg">Your transaction has been completed successfully</p>
            </div>
        </div>
    </header>

    <div class="container mx-auto px-6 py-12">
        <div class="max-w-2xl mx-auto">
            <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                <div class="p-8">
                    <div class="text-center mb-8">
                        <div class="inline-flex items-center justify-center w-20 h-20 bg-green-100 rounded-full mb-4">
                            <i class="fas fa-receipt text-3xl text-green-600"></i>
                        </div>
                        <h2 class="text-2xl font-bold text-gray-900 mb-2">Transaction Receipt</h2>
                        <p class="text-gray-600">Thank you for your purchase, <?php echo e($transaction->user_name); ?>!</p>
                    </div>

                    <div class="bg-gray-50 rounded-lg p-6 mb-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Transaction ID</label>
                                <p class="text-lg font-mono font-bold text-gray-900"><?php echo e($transactionId); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Amount Paid</label>
                                <p class="text-lg font-bold text-green-600">$<?php echo e(number_format($transaction->total_amount, 2)); ?></p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Payment Method</label>
                                <p class="text-lg font-semibold text-gray-900">
                                    <?php switch($transaction->payment_method):
                                        case ('mobile_money'): ?>
                                            <i class="fas fa-mobile-alt text-blue-500 mr-2"></i>Mobile Money
                                            <?php break; ?>
                                        <?php case ('card'): ?>
                                            <i class="fas fa-credit-card text-green-500 mr-2"></i><?php echo e($transaction->payment_details['card_type'] ?? 'Card'); ?>

                                            <?php break; ?>
                                        <?php case ('bank_transfer'): ?>
                                            <i class="fas fa-university text-purple-500 mr-2"></i>Bank Transfer
                                            <?php break; ?>
                                        <?php default: ?>
                                            <?php echo e($transaction->payment_method_display); ?>

                                    <?php endswitch; ?>
                                </p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Date & Time</label>
                                <p class="text-lg font-semibold text-gray-900"><?php echo e($transaction->created_at->format('M d, Y - h:i A')); ?></p>
                            </div>
                        </div>

                        <?php if($transaction->payment_method === 'mobile_money' && $transaction->mobile_money_phone): ?>
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <label class="block text-sm font-medium text-gray-500 mb-1">Mobile Money Phone</label>
                                <p class="text-lg font-semibold text-gray-900"><?php echo e($transaction->mobile_money_phone); ?></p>
                            </div>
                        <?php endif; ?>

                        <?php if($transaction->payment_method === 'card' && $transaction->card_last_four): ?>
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-sm font-medium text-gray-500 mb-1">Cardholder Name</label>
                                        <p class="text-lg font-semibold text-gray-900"><?php echo e($transaction->card_holder_name); ?></p>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-500 mb-1">Card Number</label>
                                        <p class="text-lg font-mono font-semibold text-gray-900">****-****-****-<?php echo e($transaction->card_last_four); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Services Purchased -->
                    <div class="mb-6">
                        <h3 class="text-lg font-bold text-gray-900 mb-4">Services Purchased</h3>
                        <div class="space-y-3">
                            <?php $__currentLoopData = $transaction->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex justify-between items-center py-3 px-4 bg-gray-50 rounded-lg">
                                    <div>
                                        <h4 class="font-semibold text-gray-900"><?php echo e($service->name); ?></h4>
                                        <?php if($service->category): ?>
                                            <span class="text-sm text-gray-500"><?php echo e(ucfirst($service->category)); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <span class="font-bold text-green-600">$<?php echo e(number_format($service->pivot->price, 2)); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        
                        <div class="mt-4 pt-4 border-t border-gray-200 flex justify-between items-center">
                            <span class="text-lg font-bold text-gray-900">Total:</span>
                            <span class="text-xl font-bold text-green-600">$<?php echo e(number_format($transaction->total_amount, 2)); ?></span>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="bg-blue-50 rounded-lg p-4 mb-6">
                        <h4 class="font-semibold text-blue-900 mb-2">
                            <i class="fas fa-info-circle mr-2"></i>What's Next?
                        </h4>
                        <div class="text-sm text-blue-800 space-y-1">
                            <?php switch($transaction->payment_method):
                                case ('mobile_money'): ?>
                                    <p>• Your mobile money account has been charged</p>
                                    <p>• You should receive an SMS confirmation shortly</p>
                                    <p>• Our team will contact you within 24 hours to begin service delivery</p>
                                    <?php break; ?>
                                <?php case ('card'): ?>
                                    <p>• Your card has been charged successfully</p>
                                    <p>• You may see this charge on your statement as "SindaSystem"</p>
                                    <p>• Our team will contact you within 24 hours to begin service delivery</p>
                                    <?php break; ?>
                                <?php case ('bank_transfer'): ?>
                                    <p>• Please complete the bank transfer using the details provided</p>
                                    <p>• We'll verify your payment within 24 hours</p>
                                    <p>• Service delivery will begin once payment is confirmed</p>
                                    <?php break; ?>
                            <?php endswitch; ?>
                            <p>• Keep this transaction ID for your records: <strong><?php echo e($transactionId); ?></strong></p>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex flex-col sm:flex-row gap-4">
                        <button 
                            onclick="window.print()" 
                            class="flex-1 bg-gray-500 hover:bg-gray-600 text-white font-bold py-3 px-6 rounded-lg transition-all duration-200 text-center"
                        >
                            <i class="fas fa-print mr-2"></i>Print Receipt
                        </button>
                        
                        <a 
                            href="<?php echo e(route('services.index')); ?>" 
                            class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg transition-all duration-200 text-center"
                        >
                            <i class="fas fa-shopping-bag mr-2"></i>Continue Shopping
                        </a>
                    </div>

                    <!-- Support Contact -->
                    <div class="mt-8 pt-6 border-t border-gray-200 text-center">
                        <p class="text-gray-600 mb-2">Need help? Contact our support team</p>
                        <div class="flex justify-center space-x-6 text-sm">
                            <span class="text-gray-500">
                                <i class="fas fa-envelope mr-1"></i>support@sindasystem.com
                            </span>
                            <span class="text-gray-500">
                                <i class="fas fa-phone mr-1"></i>+1 (555) 123-4567
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Auto-scroll to top on page load
        window.addEventListener('load', function() {
            window.scrollTo(0, 0);
        });

        // Print styles
        const printStyles = `
            <style>
                @media print {
                    body { font-size: 12px; }
                    .no-print { display: none !important; }
                    .container { max-width: none; margin: 0; padding: 0; }
                    .shadow-lg { box-shadow: none !important; }
                }
            </style>
        `;
        document.head.insertAdjacentHTML('beforeend', printStyles);
    </script>
</body>
</html>
<?php /**PATH /home/bartholomew-kapepula/Documents/Barth/sindasystem/resources/views/checkout/success.blade.php ENDPATH**/ ?>