<div>
    <!-- Flash Messages -->
    <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6 flex items-center">
            <i class="fas fa-check-circle mr-2"></i>
            <?php echo e(session('message')); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <?php if(session()->has('warning')): ?>
        <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded-lg mb-6 flex items-center">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            <?php echo e(session('warning')); ?>

        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Search and Filter Section -->
    <div class="bg-white rounded-xl shadow-lg p-6 mb-8">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <!-- Search Input -->
            <div class="relative">
                <input 
                    type="text" 
                    wire:model.live.debounce.300ms="searchTerm"
                    placeholder="Search services..."
                    class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200"
                >
                <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
            </div>

            <!-- Category Filter -->
            <div class="relative">
                <select 
                    wire:model.live="selectedCategory"
                    class="w-full pl-4 pr-10 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200 appearance-none"
                >
                    <option value="">All Categories</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category); ?>"><?php echo e(ucfirst($category)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <i class="fas fa-chevron-down absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
            </div>

            <!-- Clear Filters -->
            <button 
                wire:click="clearSearch"
                class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-6 py-3 rounded-lg transition-all duration-200 flex items-center justify-center"
            >
                <i class="fas fa-times mr-2"></i>
                Clear Filters
            </button>
        </div>
    </div>

    <!-- Services Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $this->filteredServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-xl shadow-lg overflow-hidden card-hover">
                <!-- Service Image -->
                <div class="h-48 bg-gradient-to-br from-blue-400 to-purple-500 flex items-center justify-center">
                    <!--[if BLOCK]><![endif]--><?php if(isset($service->image) && $service->image): ?>
                        <img src="<?php echo e($service->image); ?>" alt="<?php echo e($service->name); ?>" class="w-full h-full object-cover">
                    <?php else: ?>
                        <i class="fas fa-cog text-6xl text-white opacity-50"></i>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <!-- Service Content -->
                <div class="p-6">
                    <!-- Category Badge -->
                    <!--[if BLOCK]><![endif]--><?php if(isset($service->category) && $service->category): ?>
                        <span class="inline-block bg-blue-100 text-blue-800 text-xs font-semibold px-2.5 py-0.5 rounded-full mb-3">
                            <?php echo e(ucfirst($service->category)); ?>

                        </span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- Service Name -->
                    <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo e($service->name ?? 'Service Name'); ?></h3>

                    <!-- Service Description -->
                    <p class="text-gray-600 mb-4 line-clamp-3">
                        <?php echo e($service->description ?? 'Professional service tailored to meet your needs.'); ?>

                    </p>

                    <!-- Price -->
                    <!--[if BLOCK]><![endif]--><?php if(isset($service->price) && $service->price): ?>
                        <div class="flex items-center mb-4">
                            <span class="text-2xl font-bold text-green-600"><?php echo e($service->formatted_price); ?></span>
                            <!--[if BLOCK]><![endif]--><?php if(isset($service->original_price) && $service->original_price && $service->original_price > $service->price): ?>
                                <span class="text-sm text-gray-500 line-through ml-2">ZMW<?php echo e(number_format($service->original_price, 2)); ?></span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- Action Buttons -->
                    <div class="flex space-x-2">
                        <!--[if BLOCK]><![endif]--><?php if(in_array($service->id, $cart)): ?>
                            <button 
                                wire:click="removeFromCart(<?php echo e($service->id); ?>)"
                                class="flex-1 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg transition-all duration-200 flex items-center justify-center"
                            >
                                <i class="fas fa-trash mr-2"></i>
                                Remove
                            </button>
                        <?php else: ?>
                            <button 
                                wire:click="addToCart(<?php echo e($service->id); ?>)"
                                class="flex-1 bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-lg transition-all duration-200 flex items-center justify-center"
                            >
                                <i class="fas fa-plus mr-2"></i>
                                Add to Cart
                            </button>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <button class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-4 py-2 rounded-lg transition-all duration-200">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-center py-12">
                <i class="fas fa-search text-6xl text-gray-300 mb-4"></i>
                <h3 class="text-xl font-semibold text-gray-600 mb-2">No services found</h3>
                <p class="text-gray-500">Try adjusting your search criteria or browse all services.</p>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Results Summary -->
    <!--[if BLOCK]><![endif]--><?php if($this->filteredServices->count() > 0): ?>
        <div class="mt-8 text-center">
            <p class="text-gray-600">
                Showing <?php echo e($this->filteredServices->count()); ?> of <?php echo e($services->count()); ?> services
            </p>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH /home/bartholomew-kapepula/Documents/Barth/sindasystem/resources/views/livewire/services-list.blade.php ENDPATH**/ ?>