<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Services - SindaSystem</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .glass-effect {
            backdrop-filter: blur(16px) saturate(180%);
            -webkit-backdrop-filter: blur(16px) saturate(180%);
            background-color: rgba(255, 255, 255, 0.75);
            border: 1px solid rgba(209, 213, 219, 0.3);
        }
        .card-hover {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .card-hover:hover {
            transform: translateY(-8px);
            box-shadow: 0 25px 50px -12px rgba(16, 7, 71, 0.25);
        }
        
        /* Mobile menu styles */
        .mobile-menu {
            transform: translateX(-100%);
            transition: transform 0.3s ease-in-out;
        }
        .mobile-menu.active {
            transform: translateX(0);
        }
        
        /* Responsive text scaling */
        @media (max-width: 640px) {
            .hero-title {
                font-size: 2rem;
                line-height: 2.5rem;
            }
            .hero-subtitle {
                font-size: 1rem;
                line-height: 1.5rem;
            }
        }
        
        @media (min-width: 641px) and (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
                line-height: 3rem;
            }
            .hero-subtitle {
                font-size: 1.125rem;
                line-height: 1.75rem;
            }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
    <header class="gradient-bg shadow-lg">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Mobile Header -->
            <div class="flex items-center justify-between py-4 md:hidden">
                <div class="flex items-center">
                    <button id="mobile-menu-toggle" class="text-white p-2 rounded-lg hover:bg-white hover:bg-opacity-20 transition-all duration-200">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    <h1 class="text-xl font-bold text-white ml-3">
                        <i class="fas fa-cogs mr-2"></i>Services
                    </h1>
                </div>
                <a href="<?php echo e(route('cart.index')); ?>" class="glass-effect rounded-full px-4 py-2 hover:bg-white hover:bg-opacity-90 transition-all duration-200">
                    <span class="text-gray-700 font-medium text-sm">
                        <i class="fas fa-shopping-cart mr-1"></i>
                        <span class="hidden xs:inline">Cart </span>(<span id="cart-count-mobile">0</span>)
                    </span>
                </a>
            </div>

            <!-- Desktop Header -->
            <div class="hidden md:flex items-center justify-between py-6 lg:py-8">
                <div class="flex-1">
                    <h1 class="hero-title text-2xl md:text-3xl lg:text-4xl font-bold text-white mb-2">
                        <i class="fas fa-cogs mr-2 lg:mr-3"></i>Our Services
                    </h1>
                    <p class="hero-subtitle text-blue-100 text-base lg:text-lg">
                        Discover our comprehensive range of professional services
                    </p>
                </div>
                <div class="flex-shrink-0 ml-6">
                    <a href="<?php echo e(route('cart.index')); ?>" class="glass-effect rounded-full px-4 lg:px-6 py-2 lg:py-3 hover:bg-white hover:bg-opacity-90 transition-all duration-200">
                        <span class="text-gray-700 font-medium text-sm lg:text-base">
                            <i class="fas fa-shopping-cart mr-2"></i>
                            Cart (<span id="cart-count-desktop">0</span>)
                        </span>
                    </a>
                </div>
            </div>

            <!-- Mobile Slide-out Menu -->
            <div id="mobile-menu" class="mobile-menu fixed inset-y-0 left-0 z-50 w-64 bg-white shadow-xl md:hidden">
                <div class="flex items-center justify-between p-4 border-b border-gray-200">
                    <h2 class="text-lg font-semibold text-gray-900">Menu</h2>
                    <button id="mobile-menu-close" class="text-gray-500 hover:text-gray-700 p-2">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                <nav class="p-4">
                    <ul class="space-y-4">
                        <li>
                            <a href="<?php echo e(route('services.index')); ?>" class="flex items-center text-gray-700 hover:text-blue-600 transition-colors duration-200">
                                <i class="fas fa-cogs mr-3 w-5"></i>
                                All Services
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('cart.index')); ?>" class="flex items-center text-gray-700 hover:text-blue-600 transition-colors duration-200">
                                <i class="fas fa-shopping-cart mr-3 w-5"></i>
                                Shopping Cart
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex items-center text-gray-700 hover:text-blue-600 transition-colors duration-200">
                                <i class="fas fa-user mr-3 w-5"></i>
                                My Account
                            </a>
                        </li>
                        <li>
                            <a href="#" class="flex items-center text-gray-700 hover:text-blue-600 transition-colors duration-200">
                                <i class="fas fa-headset mr-3 w-5"></i>
                                Support
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>

            <!-- Mobile Menu Overlay -->
            <div id="mobile-menu-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden md:hidden"></div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="container mx-auto px-4 sm:px-6 lg:px-8 py-6 sm:py-8 lg:py-12">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('services-list');

$__html = app('livewire')->mount($__name, $__params, 'lw-258261884-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-6 sm:py-8 mt-12 sm:mt-16">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <div class="mb-4 sm:mb-6">
                    <h3 class="text-lg sm:text-xl font-semibold mb-2">SindaSystem</h3>
                    <p class="text-gray-400 text-sm sm:text-base">Professional services tailored to your needs</p>
                </div>
                
                <!-- Footer Links - Responsive Grid -->
                <div class="grid grid-cols-2 sm:grid-cols-4 gap-4 mb-6 text-sm">
                    <div>
                        <h4 class="font-semibold mb-2">Services</h4>
                        <ul class="space-y-1 text-gray-400">
                            <li><a href="#" class="hover:text-white transition-colors">Web Design</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Development</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Consulting</a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-semibold mb-2">Company</h4>
                        <ul class="space-y-1 text-gray-400">
                            <li><a href="#" class="hover:text-white transition-colors">About</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Team</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Careers</a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-semibold mb-2">Support</h4>
                        <ul class="space-y-1 text-gray-400">
                            <li><a href="#" class="hover:text-white transition-colors">Help Center</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Contact</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">FAQ</a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-semibold mb-2">Legal</h4>
                        <ul class="space-y-1 text-gray-400">
                            <li><a href="#" class="hover:text-white transition-colors">Privacy</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Terms</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Cookies</a></li>
                        </ul>
                    </div>
                </div>

                <!-- Social Links -->
                <div class="flex justify-center space-x-4 mb-6">
                    <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                        <i class="fab fa-facebook"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                        <i class="fab fa-linkedin"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition-colors text-xl">
                        <i class="fab fa-instagram"></i>
                    </a>
                </div>

                <!-- Copyright -->
                <div class="border-t border-gray-700 pt-4">
                    <p class="text-gray-400 text-xs sm:text-sm">
                        &copy; 2024 SindaSystem. All rights reserved.
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    
    <script>
        // Mobile menu functionality
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
            const mobileMenuClose = document.getElementById('mobile-menu-close');
            const mobileMenu = document.getElementById('mobile-menu');
            const mobileMenuOverlay = document.getElementById('mobile-menu-overlay');

            function openMobileMenu() {
                mobileMenu.classList.add('active');
                mobileMenuOverlay.classList.remove('hidden');
                document.body.style.overflow = 'hidden';
            }

            function closeMobileMenu() {
                mobileMenu.classList.remove('active');
                mobileMenuOverlay.classList.add('hidden');
                document.body.style.overflow = '';
            }

            mobileMenuToggle?.addEventListener('click', openMobileMenu);
            mobileMenuClose?.addEventListener('click', closeMobileMenu);
            mobileMenuOverlay?.addEventListener('click', closeMobileMenu);

            // Close menu on escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    closeMobileMenu();
                }
            });

            // Close menu when clicking on menu links
            const mobileMenuLinks = mobileMenu?.querySelectorAll('a');
            mobileMenuLinks?.forEach(link => {
                link.addEventListener('click', closeMobileMenu);
            });
        });

        // Smooth scroll for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Add loading states for better UX
        window.addEventListener('beforeunload', function() {
            document.body.style.cursor = 'wait';
        });

        // Touch gestures for mobile menu
        let touchStartX = 0;
        let touchEndX = 0;

        document.addEventListener('touchstart', function(e) {
            touchStartX = e.changedTouches[0].screenX;
        });

        document.addEventListener('touchend', function(e) {
            touchEndX = e.changedTouches[0].screenX;
            handleSwipe();
        });

        function handleSwipe() {
            const swipeThreshold = 50;
            const mobileMenu = document.getElementById('mobile-menu');
            
            // Swipe right to open menu (from left edge)
            if (touchStartX < 20 && touchEndX - touchStartX > swipeThreshold) {
                if (window.innerWidth < 768) {
                    document.getElementById('mobile-menu-toggle')?.click();
                }
            }
            
            // Swipe left to close menu
            if (touchStartX - touchEndX > swipeThreshold && mobileMenu?.classList.contains('active')) {
                document.getElementById('mobile-menu-close')?.click();
            }
        }

        // Intersection Observer for animations
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe elements for fade-in animation
        document.addEventListener('DOMContentLoaded', function() {
            const animatedElements = document.querySelectorAll('.card-hover');
            animatedElements.forEach(el => {
                el.style.opacity = '0';
                el.style.transform = 'translateY(20px)';
                el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                observer.observe(el);
            });
        });

        // Performance optimization: Lazy load images
        if ('IntersectionObserver' in window) {
            const imageObserver = new IntersectionObserver(function(entries, observer) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const img = entry.target;
                        if (img.dataset.src) {
                            img.src = img.dataset.src;
                            img.classList.remove('lazy');
                            imageObserver.unobserve(img);
                        }
                    }
                });
            });

            document.querySelectorAll('img[data-src]').forEach(img => {
                imageObserver.observe(img);
            });
        }

        // Add focus management for accessibility
        document.addEventListener('keydown', function(e) {
            // Tab navigation enhancement
            if (e.key === 'Tab') {
                document.body.classList.add('keyboard-navigation');
            }
        });

        document.addEventListener('mousedown', function() {
            document.body.classList.remove('keyboard-navigation');
        });

        // Add CSS for keyboard navigation
        const keyboardStyles = document.createElement('style');
        keyboardStyles.textContent = `
            .keyboard-navigation *:focus {
                outline: 2px solid #3b82f6 !important;
                outline-offset: 2px !important;
            }
        `;
        document.head.appendChild(keyboardStyles);
    </script>

    <!-- Additional CSS for better responsive behavior -->
    <style>
        /* Enhanced responsive utilities */
        @media (max-width: 375px) {
            .container {
                padding-left: 1rem;
                padding-right: 1rem;
            }
            
            .hero-title {
                font-size: 1.75rem;
                line-height: 2.25rem;
            }
            
            .glass-effect {
                padding: 0.5rem 0.75rem;
                font-size: 0.875rem;
            }
        }

        @media (min-width: 376px) and (max-width: 640px) {
            .xs\:inline {
                display: inline;
            }
        }

        /* Improved touch targets for mobile */
        @media (max-width: 768px) {
            button, a {
                min-height: 44px;
                min-width: 44px;
            }
            
            .card-hover {
                margin-bottom: 1rem;
            }
        }

        /* High DPI display optimizations */
        @media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
            .gradient-bg {
                background-image: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                background-size: 100% 100%;
            }
        }

        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .glass-effect {
                background-color: rgba(31, 41, 55, 0.75);
                border-color: rgba(75, 85, 99, 0.3);
            }
        }

        /* Reduced motion support */
        @media (prefers-reduced-motion: reduce) {
            .card-hover,
            .mobile-menu,
            * {
                transition: none !important;
                animation: none !important;
            }
        }

        /* Print styles */
        @media print {
            .gradient-bg,
            footer,
            #mobile-menu,
            #mobile-menu-overlay,
            .glass-effect {
                display: none !important;
            }
            
            body {
                background: white !important;
                color: black !important;
            }
        }

        /* Landscape orientation on mobile */
        @media (max-height: 500px) and (orientation: landscape) {
            .py-6 {
                padding-top: 1rem;
                padding-bottom: 1rem;
            }
            
            .hero-title {
                font-size: 1.5rem;
                line-height: 2rem;
                margin-bottom: 0.5rem;
            }
        }

        /* Ultra-wide screen support */
        @media (min-width: 1920px) {
            .container {
                max-width: 1400px;
            }
        }

        /* Loading states */
        .loading {
            opacity: 0.7;
            pointer-events: none;
        }

        .loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 20px;
            height: 20px;
            margin: -10px 0 0 -10px;
            border: 2px solid #f3f3f3;
            border-top: 2px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Accessibility improvements */
        .sr-only {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0;
        }

        /* Focus indicators */
        .focus\:ring-2:focus {
            ring-width: 2px;
        }

        .focus\:ring-blue-500:focus {
            ring-color: #3b82f6;
        }

        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Better text rendering */
        body {
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            text-rendering: optimizeLegibility;
        }
    </style>
</body>
</html>
<?php /**PATH /home/bartholomew-kapepula/Documents/Barth/sindasystem/resources/views/services/index.blade.php ENDPATH**/ ?>